﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Faktura wewnętrzna</title>
</head>

<script runat="server">


	[Context]
	public FWUENabyciaNaliczonyEwidencja Dokument
	{ get; set; }

	[Context]
	public Params Prms
	{ get; set; }


	public enum RodzajOpisu
	{
		[Caption("Podstawa prawna WNT")]
		PodstawaPrawna,

        [Caption("Podstawa prawna odwrotne obc.")]
        PodstawaPrawnaOO,

		[Caption("Opis ewidencji")]
		OpisEwidencji,

		[Caption("Opis elementu VAT")]
		OpisElementuVAT,		
	}


	public class Params : ContextBase
	{
		private RodzajOpisu kolumnaOpis;


		public Params(Context ctx) :
			base(ctx)
		{
			kolumnaOpis = RodzajOpisu.PodstawaPrawna;
		}


		[DefaultWidth(25)]
		[Caption(@"Kolumna ""Opis""")]
		public RodzajOpisu KolumnaOpis
		{
			get { return kolumnaOpis; }
			set { kolumnaOpis = value; }
		}
	}

	
	Currency bruttoSuma = new Currency(0m);

	
	public class Podsumow
	{
		DefinicjaStawkiVat elDe;
		Currency elNe;
		Currency elVa;
		Currency elBr;
		
		public Podsumow(ArrayList ar)
		{ 
		   this.ElDefStawki=(DefinicjaStawkiVat)ar[0];
		   this.ElNetto = (Currency)ar[1];
		   this.ElVAT = (Currency)ar[2];
		   this.ElBrutto = (Currency)ar[3];
		}
		public DefinicjaStawkiVat ElDefStawki
		{
			get { return elDe; }
			set { elDe = value; }
		}
		public Currency ElNetto
		{
			get { return elNe; }
			set { elNe = value; }
		}
		public Currency ElVAT
		{
			get { return elVa; }
			set { elVa = value; }
		}
		public Currency ElBrutto
		{
			get { return elBr; }
			set { elBr = value; }
		}
	}

	
	ArrayList Podsum = new ArrayList();
	ArrayList Podsum2 = new ArrayList();



	private String GetNIP(IDokumentPodmiotu dok, string euvat)
	{
		string country;
		string nip;
		
		EuVat.Split(euvat, out country, out nip);
		if (dok.Podmiot != null)
			switch (Dokument.Podmiot.RodzajPodmiotu)
			{
				case RodzajPodmiotu.Unijny:
				case RodzajPodmiotu.UnijnyTrójstronny:
					if (country == "")
                        country = "PL";
					return country + " " + nip.Replace("-", "");
			}
		
		return nip;
	}


	void OnContextLoad(Object sender, EventArgs args)
	{
		IdPrintTitle.EditValue = Dokument.Definicja.Nazwa.Replace("FW", "Faktura wewnętrzna").Replace("DW", "Dokument wewnętrzny");
		
		
		foreach (ElemEwidencjiVAT elem in Dokument.NagEwidencjiVAT.Elementy)
		{
			ArrayList el = new ArrayList();
			el.Add(elem.DefinicjaStawki);
			el.Add(elem.Netto);
			el.Add(elem.VAT);
			el.Add(elem.Brutto);

			//znajdz indeks
			int poz = -1;
			int k = 0;
			foreach (ArrayList o in Podsum)
			{
				if (o[0] == elem.DefinicjaStawki)
				{
					poz = k;
					break;
				}
				k++;
			}

			//dopisz element do Podsum
			//jesli nie ma - nowy element
			if (poz < 0)
			{
				Podsum.Add(el);
			}
			//jesli jest taka stawka zsumuj wartosci element
			else
			{
				foreach (ArrayList o in Podsum)
				{
					o[1] = (Currency)o[1] + elem.Netto;
					o[2] = (Currency)o[2] + elem.VAT;
					o[3] = (Currency)o[3] + elem.Brutto;
					break;
				}
			}
			//Razem
			bruttoSuma += elem.Brutto;
		}

		for (int i = 0; i < Podsum.Count; i++)
		{
			Podsum2.Add(new Podsumow((ArrayList)Podsum[i]));
		}

		//wyniki w Podsum
		Grid5.DataSource = Podsum2;

		DataLabel5.EditValue = bruttoSuma.ToString();
		DataLabel6.EditValue = bruttoSuma.Słownie;

		//Formatujemy podpisy
		stPodpis.Caption = "<font size=2>" + Dokument.Session.Login.Operator.FullName + "</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
		stOsoba.Caption = "<br><br><font size=1>..................................................<br>Podpis osoby upoważnionej do otrzymania dokumentu</font>";

        // adres z pieczątki historyczny

	    var pieczatka = ReportHeader.GetPieczątka(dc, null, false);
	    IdPieczatka.EditValue = pieczatka.NazwaFormatowana;
	    IdAdres1.EditValue = pieczatka.Adres.Linia1;
	    IdAdres2.EditValue = pieczatka.Adres.Linia2;
		poleNIP.EditValue = GetNIP(Dokument, pieczatka.EuVAT);
    }


	private void Opis_BeforeRow(object sender, RowEventArgs args)
	{
		switch (Prms.KolumnaOpis)
		{
			case RodzajOpisu.PodstawaPrawna:
				this.GridColumnOpis.EditValue = "Podstawa opodatkowania zgodnie z art. 30a. ustawy z dnia 11 marca 2004r. o podatku od towarów i usług.";
				break;

            case RodzajOpisu.PodstawaPrawnaOO:
                this.GridColumnOpis.EditValue = "Podstawa opodatkowania zgodnie z art. 17 ust. 1 pkt 7-8 ustawy z dnia 11 marca 2004r. o podatku od towarów i usług.";
				break;

			case RodzajOpisu.OpisEwidencji:
				this.GridColumnOpis.EditValue = Dokument.Opis;
				break;

			case RodzajOpisu.OpisElementuVAT:
				this.GridColumnOpis.EditValue = ((ElemEwidencjiVAT)args.Row).OpisDodatkowy;
				break;
		}
	}	
	
			
</script>

<body>
	<form method="post" runat="server" ID="form">
		<ea:DataContext id="dc" runat="server" TypeName="Soneta.EwidencjaVat.FWUENabyciaNaliczonyEwidencja,Soneta.Ksiega" OnContextLoad="OnContextLoad" />
   
		<div style="width: 100%; border-bottom: 1px solid">
			<table id="Table4" style="font-size: xx-small; font-family: Tahoma" width="100%">
				<tr>
					<td style="font-weight: bold; font-size: medium" valign="top" align="left">
						<ea:DataLabel ID="IdPrintTitle" runat="server" /><br /><ea:DataLabel ID="DataLabel15" runat="server" DataMember="Numer" />
					</td>
					<td valign="top" align="right">
						Data wystawienia<br/>Data operacji<br/>Data wpływu:
					</td>
					<td width="10"></td>
					<td valign="top" align="right">
						<ea:DataLabel ID="DataLabel21" runat="server" DataMember="DataDokumentu" EncodeHTML="True" /><br/>
						<ea:DataLabel ID="DataLabel22" runat="server" DataMember="DataOperacji" EncodeHTML="True"/><br/>
						<ea:DataLabel ID="DataLabel27" runat="server" DataMember="DataWplywu" EncodeHTML="True"/>
					</td>
				</tr>
			</table>
		</div>

		<p />

		<table id="Table1" width="100%">
			<tr>
				<td valign="top" width="55%">
					<em><u>Nabywca:</u></em>
					<div style="font-size: x-small; left: 10px; font-family: Tahoma; position: relative">
						<ea:DataLabel ID="IdPieczatka" runat="server" EncodeHTML="True" /><br/>
						<ea:DataLabel ID="IdAdres1" runat="server" Bold="False" EncodeHTML="True" /><br />
						<ea:DataLabel ID="IdAdres2" runat="server" Bold="False" EncodeHTML="True" /><br />
						NIP: <ea:DataLabel ID="poleNIP" runat="server" Bold="False" EncodeHTML="True" />
					</div>
				</td>
				<td valign="top" >
					<em><u>Sprzedawca:</u></em>
					<div style="font-size: x-small; left: 10px; font-family: Tahoma; position: relative">
						<ea:DataLabel ID="DataLabel1" runat="server" DataMember="DaneKontrahenta.NazwaFormatowana" EncodeHTML="True" /><br />
						<ea:DataLabel ID="DataLabel2" runat="server" DataMember="DaneKontrahenta.Adres.Linia1" Bold="False" EncodeHTML="True" /><br />
						<ea:DataLabel ID="DataLabel3" runat="server" DataMember="DaneKontrahenta.Adres.Linia2" Bold="False" EncodeHTML="True" /><br />
						NIP: <ea:DataLabel ID="DataLabel11" runat="server" DataMember="DaneKontrahenta.EuVAT" Bold="False" EncodeHTML="True" /><br />
					</div>
				</td>
			</tr>
		</table>
		
		<p />

		<ea:Grid ID="Grid1" runat="server" DataMember="NagEwidencjiVAT.Elementy" OnBeforeRow="Opis_BeforeRow" RowTypeName="Soneta.EwidencjaVat.FWUENabyciaNaliczonyEwidencja,Soneta.Ksiega">
			<Columns>
				<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp."/>
				<ea:GridColumn runat="server" Align="Left" Caption="Opis" ID="GridColumnOpis" EncodeHTML="True" />
				<ea:GridColumn runat="server" Width="8" Align="Center" DataMember="Rodzaj" Caption="Rodzaj" EncodeHTML="True" />
				<ea:GridColumn runat="server" Width="10" Align="Center" DataMember="DefinicjaStawki" Caption="Stawka VAT" ID="vat" EncodeHTML="True" />
				<ea:GridColumn runat="server" Width="18" Align="Right" DataMember="Netto" Caption="Kwota netto" ID="cena" />
				<ea:GridColumn runat="server" Width="17" Align="Right" DataMember="VAT" Caption="Kwota VAT" />
				<ea:GridColumn runat="server" Width="18" Align="Right" DataMember="Brutto" Caption="Kwota brutto" />
			</Columns>
		</ea:Grid>

		<p />

		<div style="text-align:right;">
			<ea:Grid ID="Grid5" runat="server">
				<Columns>
					<ea:GridColumn runat="server" Width="15" Align="Right" ID="Definicja_Stawki" Total="Info" Caption="Stawka VAT" EncodeHTML="True" DataMember="ElDefStawki" />
					<ea:GridColumn runat="server" Width="17" Align="Right" ID="Suma_Netto" Format="{0:n}" Total="Sum" Caption="Netto" EncodeHTML="True" DataMember="ElNetto" />
					<ea:GridColumn runat="server" Width="17" Align="Right" ID="Suma_VAT" Format="{0:n}" Total="Sum" Caption="Kwota VAT" EncodeHTML="True" DataMember="ElVAT" />
					<ea:GridColumn runat="server" Width="17" Align="Right" ID="Suma_Brutto" Format="{0:n}" Total="Sum" Caption="Brutto" EncodeHTML="True" DataMember="ElBrutto" />
				</Columns>
			</ea:Grid>
		</div>

		<p />

		<table id="Table3" cellspacing="0" cellpadding="0" width="100%">
			<tr>
				<td style="width: 151px; height: 22px;" align="right"></td>
				<td style="width: 145px; border-bottom: black 1px solid; height: 22px;" valign="bottom" align="left" width="145" colspan="1" rowspan="1">Wartość:</td>
				<td style="font-weight: bold; font-size: medium; border-bottom: black 1px solid; height: 22px" valign="bottom" align="right"> 
					<ea:DataLabel ID="DataLabel5" runat="server" Bold="False" Format="{0:+u}" EncodeHTML="True" />
				</td>
			</tr>
			<tr>
				<td style="width: 151px" align="right"></td>
				<td style="width: 145px" align="left"><font size="2"><em>Słownie:</em></font></td>
				<td align="right"><font size="2"><em><ea:DataLabel ID="DataLabel6" runat="server" Bold="False" Format="{0:+t}" EncodeHTML="True" /></em></font></td>
			</tr>
		</table>

		<p />
		
	   <cc1:ReportFooter ID="ReportFooter1" runat="server" Height="105px" WithSections="false" >
			<Subtitles>
				<cc1:FooterSubtitle ID="stPodpis" runat="server" Caption="Operator" SubtitleType="CenterText" Width="50" />
				<cc1:FooterSubtitle ID="stOsoba" runat="server" Caption="Osoba" SubtitleType="CenterText" Width="50" />
			</Subtitles>
		</cc1:ReportFooter>
	</form>
</body>
</html>

